define("mod_quiz/edit_multiple_grades",["exports","core/ajax","core/config","core/loadingicon","core/notification","core/pending","core/str","core/templates"],(function(_exports,_ajax,_config,_loadingicon,_notification,_pending,_str,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * JavaScript for managing multiple grade items for a quiz.
   *
   * @module     mod_quiz/edit_multiple_grades
   * @copyright  2023 The Open University
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_config=_interopRequireDefault(_config),_notification=_interopRequireDefault(_notification),_pending=_interopRequireDefault(_pending);const SELECTORS_addGradeItemButton="#mod_quiz-add_grade_item",SELECTORS_autoSetupButton="#mod_quiz-grades_auto_setup",SELECTORS_editingPageContents="#edit_grading_page-contents",SELECTORS_gradeItemList="table#mod_quiz-grade-item-list",SELECTORS_gradeItemSelect="select[data-slot-id]",SELECTORS_gradeItemSelectId=id=>"select#grade-item-choice-"+id,SELECTORS_gradeItemTr="table#mod_quiz-grade-item-list tr[data-quiz-grade-item-id]",SELECTORS_inplaceEditable="span.inplaceeditable",SELECTORS_inplaceEditableOn="span.inplaceeditable.inplaceeditingon",SELECTORS_resetAllButton="#mod_quiz-grades_reset_all",SELECTORS_slotList="table#mod_quiz-slot-list",SELECTORS_updateGradeItemLink=id=>'tr[data-quiz-grade-item-id="'+id+'"] .quickeditlink',callServiceAndReturnRenderingData=methodCall=>callServicesAndReturnRenderingData([methodCall]),callServicesAndReturnRenderingData=methodCalls=>(methodCalls.push({methodname:"mod_quiz_get_edit_grading_page_data",args:{quizid:methodCalls[0].args.quizid}}),Promise.all((0,_ajax.call)(methodCalls)).then((results=>JSON.parse(results.at(-1))))),handleGradeItemDelete=e=>{e.preventDefault();const pending=new _pending.default("delete-quiz-grade-item"),tableCell=e.target.closest("td");(0,_loadingicon.addIconToContainer)(tableCell,pending);const tableRow=tableCell.closest("tr"),quizId=tableRow.closest("table").dataset.quizId,gradeItemId=tableRow.dataset.quizGradeItemId;let nextItemToFocus;nextItemToFocus=tableRow.nextElementSibling?SELECTORS_updateGradeItemLink(tableRow.nextElementSibling.dataset.quizGradeItemId):SELECTORS_addGradeItemButton,((quizId,gradeItemId)=>callServiceAndReturnRenderingData({methodname:"mod_quiz_delete_grade_items",args:{quizid:quizId,quizgradeitems:[{id:gradeItemId}]}}))(quizId,gradeItemId).then(reRenderPage).then((()=>{pending.resolve(),document.querySelector(nextItemToFocus).focus()})).catch(_notification.default.exception)},stopEditingGadeItem=editableSpan=>{editableSpan.innerHTML=editableSpan.dataset.oldContent,delete editableSpan.dataset.oldContent,editableSpan.classList.remove("inplaceeditingon"),editableSpan.querySelector("[data-action-edit]").focus()},handleGradeItemKeyDown=e=>{if(13!==e.keyCode)return;const editableSpan=e.target.closest(SELECTORS_inplaceEditableOn);if(!editableSpan||!editableSpan.closest(SELECTORS_gradeItemList))return;e.preventDefault();const pending=new _pending.default("edit-quiz-grade-item-save"),newName=editableSpan.querySelector("input").value,tableCell=e.target.closest("th");(0,_loadingicon.addIconToContainer)(tableCell);const tableRow=tableCell.closest("tr"),quizId=tableRow.closest("table").dataset.quizId,gradeItemId=tableRow.dataset.quizGradeItemId;((quizId,gradeItemId,newName)=>callServiceAndReturnRenderingData({methodname:"mod_quiz_update_grade_items",args:{quizid:quizId,quizgradeitems:[{id:gradeItemId,name:newName}]}}))(quizId,gradeItemId,newName).then(reRenderPage).then((()=>{pending.resolve(),document.querySelector(SELECTORS_updateGradeItemLink(gradeItemId)).focus({focusVisible:!0})})).catch(_notification.default.exception)},reRenderPage=editGradingPageData=>(0,_templates.render)("mod_quiz/edit_grading_page",editGradingPageData).then(((html,js)=>(0,_templates.replaceNode)(document.querySelector(SELECTORS_editingPageContents),html,js||""))),handleGradeItemKeyUp=e=>{if(27!==e.keyCode)return;const editableSpan=e.target.closest(SELECTORS_inplaceEditableOn);editableSpan&&editableSpan.closest(SELECTORS_gradeItemList)&&(e.preventDefault(),stopEditingGadeItem(editableSpan))},handleGradeItemFocusOut=e=>{if(_config.default.behatsiterunning)return;const editableSpan=e.target.closest(SELECTORS_inplaceEditableOn);editableSpan&&editableSpan.closest(SELECTORS_gradeItemList)&&(e.preventDefault(),stopEditingGadeItem(editableSpan))},handleSlotGradeItemChanged=e=>{const select=e.target.closest(SELECTORS_gradeItemSelect);if(!select||!select.closest(SELECTORS_slotList))return;e.preventDefault();const pending=new _pending.default("edit-slot-grade-item-updated"),slotId=select.dataset.slotId,newGradeItemId=select.value?select.value:null,tableCell=e.target.closest("td");(0,_loadingicon.addIconToContainer)(tableCell,pending);((quizId,slotId,gradeItemId)=>callServiceAndReturnRenderingData({methodname:"mod_quiz_update_slots",args:{quizid:quizId,slots:[{id:slotId,quizgradeitemid:gradeItemId}]}}))(tableCell.closest("table").dataset.quizId,slotId,newGradeItemId).then(reRenderPage).then((()=>{pending.resolve(),document.querySelector(SELECTORS_gradeItemSelectId(slotId)).focus()})).catch(_notification.default.exception)},handleGradeItemClick=e=>{const link=e.target.closest("a");link&&link.closest(SELECTORS_gradeItemList)&&(link.dataset.actionDelete&&handleGradeItemDelete(e),link.dataset.actionEdit&&(e=>{e.preventDefault();const pending=new _pending.default("edit-quiz-grade-item-start"),editableSpan=e.target.closest(SELECTORS_inplaceEditable);document.querySelectorAll(SELECTORS_inplaceEditableOn).forEach(stopEditingGadeItem),editableSpan.dataset.oldContent=editableSpan.innerHTML,(0,_str.get_string)("edittitleinstructions").then((instructions=>{const uniqueId="gi-edit-input-"+editableSpan.closest("tr").dataset.quizGradeItemId;editableSpan.innerHTML='<span class="editinstructions">'+instructions+'</span><label class="visually-hidden" for="'+uniqueId+'">'+editableSpan.dataset.editLabel+'</label><input type="text" id="'+uniqueId+'" value="'+editableSpan.dataset.rawName+'" class="ignoredirty form-control w-100">';const inputElement=editableSpan.querySelector("input");return inputElement.focus(),inputElement.select(),editableSpan.classList.add("inplaceeditingon"),pending.resolve(),null})).catch(_notification.default.exception)})(e))},handleButtonClick=e=>{e.target.closest(SELECTORS_addGradeItemButton)&&handleAddGradeItemClick(e),e.target.closest(SELECTORS_autoSetupButton)&&handleAutoSetup(e),e.target.closest(SELECTORS_resetAllButton)&&handleResetAllClick(e)},handleAddGradeItemClick=e=>{e.preventDefault();const pending=new _pending.default("create-quiz-grade-item");(0,_loadingicon.addIconToContainer)(e.target.parentNode,pending);(quizId=>callServiceAndReturnRenderingData({methodname:"mod_quiz_create_grade_items",args:{quizid:quizId,quizgradeitems:[{name:""}]}}))(e.target.dataset.quizId).then(reRenderPage).then((()=>{pending.resolve(),document.querySelector(SELECTORS_addGradeItemButton).focus()})).catch(_notification.default.exception)},handleAutoSetup=e=>{e.preventDefault();const pending=new _pending.default("setup-quiz-grade-items");(quizId=>callServiceAndReturnRenderingData({methodname:"mod_quiz_create_grade_item_per_section",args:{quizid:quizId}}))(e.target.dataset.quizId).then(reRenderPage).then((()=>{pending.resolve(),document.querySelector(SELECTORS_resetAllButton).focus()})).catch(_notification.default.exception)},handleResetAllClick=e=>{e.preventDefault();const button=e.target;_notification.default.deleteCancelPromise((0,_str.get_string)("gradeitemsremoveallconfirm","quiz"),(0,_str.get_string)("gradeitemsremoveallmessage","quiz"),(0,_str.get_string)("reset"),button).then((()=>reallyResetAll(button))).catch((()=>button.focus()))},reallyResetAll=button=>{const pending=new _pending.default("reset-quiz-grading");(0,_loadingicon.addIconToContainer)(button.parentNode,pending);const quizId=button.dataset.quizId;let methodCalls=[];const slotResets=[...document.querySelectorAll(SELECTORS_gradeItemSelect)].map((select=>({id:select.dataset.slotId,quizgradeitemid:0})));slotResets.length&&methodCalls.push({methodname:"mod_quiz_update_slots",args:{quizid:quizId,slots:slotResets}}),methodCalls.push({methodname:"mod_quiz_delete_grade_items",args:{quizid:quizId,quizgradeitems:[...document.querySelectorAll(SELECTORS_gradeItemTr)].map((tr=>({id:tr.dataset.quizGradeItemId})))}}),callServicesAndReturnRenderingData(methodCalls).then(reRenderPage).then((()=>{pending.resolve(),document.querySelector(SELECTORS_addGradeItemButton).focus()})).catch(_notification.default.exception)};_exports.init=()=>{document.body.addEventListener("click",handleGradeItemClick),document.body.addEventListener("keydown",handleGradeItemKeyDown),document.body.addEventListener("keyup",handleGradeItemKeyUp),document.body.addEventListener("focusout",handleGradeItemFocusOut),document.body.addEventListener("click",handleButtonClick),document.body.addEventListener("change",handleSlotGradeItemChanged)}}));

//# sourceMappingURL=edit_multiple_grades.min.js.map